/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceFilterSelectionActionListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceMouseActionListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceTableSorter;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ExportConcordanceActionListener;
import net.nooj4nlp.controller.ConcordanceShell.ExtractConcordanceActionListener;
import net.nooj4nlp.controller.ConcordanceShell.RightClickPopupMenuForConcordance;
import net.nooj4nlp.controller.ConcordanceShell.TextBoxConcordanceActionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.actions.shells.construct.OpenStatsActionListener;
import net.nooj4nlp.gui.actions.shells.construct.SyntacticTreeActionListener;
import net.nooj4nlp.gui.actions.shells.control.ConcordanceCommandInternalFrameListener;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.shells.CustomInternalFrameListener;
import net.nooj4nlp.gui.utilities.Helper;

public class ConcordanceShell
extends JInternalFrame {
    private static final long serialVersionUID = 4359582798272725945L;
    private ConcordanceShellController controller;
    private TextEditorShellController textController;
    private JRadioButton rbCharacters;
    private JRadioButton rbWordForms;
    private JTable concordanceTable;
    private JCheckBox cbMatches;
    private JCheckBox cbOutputs;
    private JLabel entriesNBLabel;
    private JTextField beforeTF;
    private JTextField afterTF;
    private JLabel queryNameLabel;
    private boolean rbCharactersIsSelected = false;
    private JMenu mnConcordance;
    private JMenuItem mntmAddRemoveAnnotations;
    private JMenuItem mntmDisplaySyntacticAnalysis;
    private CustomForegroundTableRenderer customForegroundTableRenderer;

    public ConcordanceShell(TextEditorShellController textController) {
        this.textController = textController;
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        if (textController != null) {
            this.setTitle("Concordance for Text " + textController.getTextName());
            Helper.putDialogOnTheTop(textController.getTextShell());
            Helper.putDialogOnTheTop(this);
        } else {
            this.setTitle("Concordance");
        }
        this.setBounds(50, 50, 750, 420);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("insets 5", "[500::, grow]", "[::30, center][grow][::20]"));
        JButton resetButton = new JButton("Reset");
        this.getContentPane().add((Component)resetButton, "cell 0 0, align left, split 9, gapright 20");
        JLabel displayLabel = new JLabel("Display:");
        this.getContentPane().add((Component)displayLabel, "cell 0 0, align left");
        this.beforeTF = new JTextField(4);
        this.beforeTF.setText("5");
        this.beforeTF.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.beforeTF, "cell 0 0, align left, wrap 30, wmin 30");
        JPanel rbPanel = new JPanel();
        this.getContentPane().add((Component)rbPanel, "cell 0 0, gapright 10");
        rbPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[fill]", "[::15][::15]"));
        this.rbCharacters = new JRadioButton("characters");
        rbPanel.add((Component)this.rbCharacters, "cell 0 0, gaptop 1");
        this.rbWordForms = new JRadioButton("word forms");
        rbPanel.add((Component)this.rbWordForms, "cell 0 1, gapbottom 5");
        this.rbWordForms.setSelected(true);
        ButtonGroup rbGroup = new ButtonGroup();
        rbGroup.add(this.rbCharacters);
        rbGroup.add(this.rbWordForms);
        JLabel beforeAndLabel = new JLabel(" before, and ");
        this.getContentPane().add((Component)beforeAndLabel, "cell 0 0");
        this.afterTF = new JTextField(4);
        this.afterTF.setText("5");
        this.afterTF.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.afterTF, "cell 0 0, align left, wrap 30, wmin 30");
        if (ConcordanceShellController.getBefore() != 0) {
            this.beforeTF.setText(Integer.toString(ConcordanceShellController.getBefore()));
            this.afterTF.setText(Integer.toString(ConcordanceShellController.getAfter()));
        }
        JLabel afterDisplayLabel = new JLabel(" after. Display:");
        this.getContentPane().add((Component)afterDisplayLabel, "cell 0 0, align right");
        this.cbMatches = new JCheckBox("Matches");
        this.getContentPane().add((Component)this.cbMatches, "cell 0 0, align right");
        this.cbMatches.setSelected(true);
        this.cbOutputs = new JCheckBox("Outputs");
        this.getContentPane().add((Component)this.cbOutputs, "cell 0 0, align right");
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"", "Before", "Seq.", "After", "Color", "Tag"}, 0);
        this.concordanceTable = new JTable(tableModel){
            private static final long serialVersionUID = 7039783882968364592L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.concordanceTable.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            // empty if block
                        }
                    }
                };
            }
        });
        this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(5));
        this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(4));
        this.customForegroundTableRenderer = new CustomForegroundTableRenderer();
        this.concordanceTable.setDefaultRenderer(Object.class, this.customForegroundTableRenderer);
        this.concordanceTable.setAutoCreateRowSorter(false);
        JScrollPane scrollPane = new JScrollPane(this.concordanceTable, 20, 30);
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane, "cell 0 1, grow");
        this.concordanceTable.setAutoResizeMode(0);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(tableModel);
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        sorter.setSortable(2, false);
        sorter.setSortable(3, false);
        this.concordanceTable.setRowSorter(sorter);
        this.queryNameLabel = new JLabel("Query");
        this.getContentPane().add((Component)this.queryNameLabel, "cell 0 2, split 2, gapright 250");
        this.entriesNBLabel = new JLabel("");
        this.getContentPane().add((Component)this.entriesNBLabel, "cell 0 2");
        this.controller = new ConcordanceShellController(this);
        if (this.controller.isRbCharactersIsPressed()) {
            this.rbCharacters.setSelected(true);
        } else {
            this.rbCharacters.setSelected(false);
        }
        if (this.controller.isCbMatchesIsPressed()) {
            this.cbMatches.setSelected(true);
        } else {
            this.cbMatches.setSelected(false);
        }
        if (this.controller.isCbOutputsIsPressed()) {
            this.cbOutputs.setSelected(true);
        } else {
            this.cbOutputs.setSelected(false);
        }
        this.beforeTF.addKeyListener(new TextBoxConcordanceActionListener(this.beforeTF, this.afterTF, this.controller));
        this.afterTF.addKeyListener(new TextBoxConcordanceActionListener(this.beforeTF, this.afterTF, this.controller));
        this.concordanceTable.getTableHeader().addMouseListener(new ConcordanceTableSorter(this.controller, this.concordanceTable));
        this.concordanceTable.setSelectionBackground(new Color(109, 182, 255));
        ListSelectionModel rowSelectionModel = this.concordanceTable.getSelectionModel();
        rowSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = ConcordanceShell.this.concordanceTable.getSelectedRows();
                DefaultTableModel tableModel = (DefaultTableModel)ConcordanceShell.this.concordanceTable.getModel();
                if (selectedRows.length > 0) {
                    List<Object> theItems = ConcordanceShell.this.controller.getTheItems();
                    for (int i = 0; i < theItems.size(); i += 4) {
                        Object[] item = (Object[])theItems.get(i + 1);
                        if (!tableModel.getValueAt(selectedRows[0], 0).equals(item[0]) || !tableModel.getValueAt(selectedRows[0], 1).equals(item[1]) || !tableModel.getValueAt(selectedRows[0], 2).equals(item[2]) || !tableModel.getValueAt(selectedRows[0], 3).equals(item[3]) || !tableModel.getValueAt(selectedRows[0], 4).equals(item[4]) || !tableModel.getValueAt(selectedRows[0], 5).equals(item[5])) continue;
                        ConcordanceShell.this.queryNameLabel.setText(theItems.get(i).toString());
                        break;
                    }
                }
            }
        });
        this.concordanceTable.addMouseListener(new ConcordanceMouseActionListener(this.controller));
        this.addInternalFrameListener(new ConcordanceCommandInternalFrameListener(this.controller));
        this.addMouseListener(new RightClickPopupMenuForConcordance(this.controller));
        this.concordanceTable.addMouseListener(new RightClickPopupMenuForConcordance(this.controller));
        this.addInternalFrameListener(new CustomInternalFrameListener(textController, this.controller, this.customForegroundTableRenderer));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConcordanceShell.this.controller.reset();
            }
        });
        this.rbCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConcordanceShell.this.rbCharactersIsSelected) {
                    ConcordanceShell.this.beforeTF.setText(Integer.toString(ConcordanceShellController.getBefore() * 10));
                    ConcordanceShell.this.afterTF.setText(Integer.toString(ConcordanceShellController.getAfter() * 10));
                    ConcordanceShell.this.controller.radioButtonEvent(true);
                }
                ConcordanceShell.this.rbCharactersIsSelected = true;
            }
        });
        this.rbWordForms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConcordanceShell.this.rbCharactersIsSelected) {
                    int before = ConcordanceShellController.getBefore();
                    int after = ConcordanceShellController.getAfter();
                    ConcordanceShell.this.beforeTF.setText(Integer.toString((before - before % 10) / 10));
                    ConcordanceShell.this.afterTF.setText(Integer.toString((after - after % 10) / 10));
                    ConcordanceShell.this.controller.radioButtonEvent(false);
                }
                ConcordanceShell.this.rbCharactersIsSelected = false;
            }
        });
        this.cbMatches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConcordanceShell.this.controller.refreshConcordance();
                if (!ConcordanceShell.this.cbMatches.isSelected()) {
                    ConcordanceShell.this.controller.setCbMatchesIsPressed(false);
                } else {
                    ConcordanceShell.this.controller.setCbMatchesIsPressed(true);
                }
                ConcordanceShell.this.controller.setWidthOfTableColumn(ConcordanceShell.this.concordanceTable, (DefaultTableModel)ConcordanceShell.this.concordanceTable.getModel(), 2);
            }
        });
        this.cbOutputs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConcordanceShell.this.controller.refreshConcordance();
            }
        });
        this.mnConcordance = this.createConcordanceMenu();
    }

    private JMenu createConcordanceMenu() {
        JMenu mnConcordance = new JMenu("CONCORDANCE");
        JMenuItem mntmSelectAll = new JMenuItem("Select all");
        mnConcordance.add(mntmSelectAll);
        mntmSelectAll.addActionListener(new ConcordanceFilterSelectionActionListener(this.controller, true, false, false));
        JMenuItem mntmUnselectAll = new JMenuItem("Unselect all");
        mnConcordance.add(mntmUnselectAll);
        mntmUnselectAll.addActionListener(new ConcordanceFilterSelectionActionListener(this.controller, false, false, false));
        JMenuItem mntmFilterSelectedLines = new JMenuItem("Filter out selected lines");
        mnConcordance.add(mntmFilterSelectedLines);
        mntmFilterSelectedLines.addActionListener(new ConcordanceFilterSelectionActionListener(this.controller, false, true, true));
        JMenuItem mntmFilterUnselectedLines = new JMenuItem("Filter out unselected lines");
        mnConcordance.add(mntmFilterUnselectedLines);
        mntmFilterUnselectedLines.addActionListener(new ConcordanceFilterSelectionActionListener(this.controller, false, true, false));
        JMenuItem mntmRepeatSegmentsHideHapaxes = new JMenuItem("Repeted segments only / Hide hapaxes");
        mnConcordance.add(mntmRepeatSegmentsHideHapaxes);
        mntmRepeatSegmentsHideHapaxes.addActionListener(new ConcordanceFilterSelectionActionListener(this.controller));
        JSeparator separator_1 = new JSeparator();
        mnConcordance.add(separator_1);
        this.mntmAddRemoveAnnotations = new JMenuItem("Annotate Text (add/remove annotations)");
        mnConcordance.add(this.mntmAddRemoveAnnotations);
        this.mntmAddRemoveAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    CursorChangeEffect.setCustomCursor(3);
                    ConcordanceShell.this.controller.annotate();
                }
                finally {
                    CursorChangeEffect.setCustomCursor(0);
                }
            }
        });
        this.mntmDisplaySyntacticAnalysis = new JMenuItem("Display Syntactic Analysis");
        mnConcordance.add(this.mntmDisplaySyntacticAnalysis);
        this.mntmDisplaySyntacticAnalysis.addActionListener(new SyntacticTreeActionListener(this.controller));
        JSeparator separator_2 = new JSeparator();
        mnConcordance.add(separator_2);
        JMenuItem mntmExportConcordanceAsText = new JMenuItem("Export Concordance As TXT");
        mnConcordance.add(mntmExportConcordanceAsText);
        mntmExportConcordanceAsText.addActionListener(new ExportConcordanceActionListener(this.controller, 1));
        JMenuItem mntmExportConcordanceAsWeb = new JMenuItem("Export Concordance As Web Page");
        mnConcordance.add(mntmExportConcordanceAsWeb);
        mntmExportConcordanceAsWeb.addActionListener(new ExportConcordanceActionListener(this.controller, 2));
        JMenuItem mntmExportIndex = new JMenuItem("Export Index");
        mnConcordance.add(mntmExportIndex);
        mntmExportIndex.addActionListener(new ExportConcordanceActionListener(this.controller, 3));
        JMenuItem mntmExtractMatchingTU = new JMenuItem("Extract Matching Text Units");
        mnConcordance.add(mntmExtractMatchingTU);
        mntmExtractMatchingTU.addActionListener(new ExtractConcordanceActionListener(this.controller, true));
        JMenuItem mntmExtractNonMatchingTU = new JMenuItem("Extract Non Matching Text Units");
        mnConcordance.add(mntmExtractNonMatchingTU);
        mntmExtractNonMatchingTU.addActionListener(new ExtractConcordanceActionListener(this.controller, false));
        JMenuItem mntmStatisticalAnalyses = new JMenuItem("Statistical Analyses");
        mnConcordance.add(mntmStatisticalAnalyses);
        mntmStatisticalAnalyses.addActionListener(new OpenStatsActionListener(this.controller.getTextController(), this.controller));
        return mnConcordance;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public JRadioButton getRbCharacters() {
        return this.rbCharacters;
    }

    public JRadioButton getRbWordForms() {
        return this.rbWordForms;
    }

    public JTable getConcordanceTable() {
        return this.concordanceTable;
    }

    public JCheckBox getCbMatches() {
        return this.cbMatches;
    }

    public JCheckBox getCbOutputs() {
        return this.cbOutputs;
    }

    public JLabel getEntriesNBLabel() {
        return this.entriesNBLabel;
    }

    public ConcordanceShellController getController() {
        return this.controller;
    }

    public JTextField getBeforeTF() {
        return this.beforeTF;
    }

    public JTextField getAfterTF() {
        return this.afterTF;
    }

    public CustomForegroundTableRenderer getCustomForegroundTableRenderer() {
        return this.customForegroundTableRenderer;
    }

    public JMenu getMnConcordance() {
        return this.mnConcordance;
    }

    public JMenuItem getMntmAddRemoveAnnotations() {
        return this.mntmAddRemoveAnnotations;
    }

    public JMenuItem getMntmDisplaySyntacticAnalysis() {
        return this.mntmDisplaySyntacticAnalysis;
    }
}

